#!/usr/bin/env bash
#
# Opens two reverse-SSH tunnels on each of three servers.
#   • :2567  → localhost:2567
#   • :8080  → localhost:1234
#
# Edit USERNAME and the SERVERS array to match your setup.

set -euo pipefail

USERNAME="<username>"

# Exactly three server hostnames or IPs:
SERVERS=(
  "<server1>"
  "<server2>"
  "<server3>"
)

for HOST in "${SERVERS[@]}"; do
  echo "[$HOST] starting tunnels as $USERNAME …"

  ssh -f -N \
      -R :2567:localhost:2567 \
      -R :8080:localhost:1234 \
      "$USERNAME@$HOST"

  echo "[$HOST] ✔ tunnels active"
done

echo "All tunnels started.  Use \`pgrep -f 'ssh.*-R'\` to list them."
